﻿# Create a Restore Point – Make a full system restore point as a safety net before making changes.

# Load Windows Forms assembly for MessageBox
Add-Type -AssemblyName System.Windows.Forms

# Check for administrator rights
if (-not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] "Administrator")) {
    [System.Windows.Forms.MessageBox]::Show(
        "You need to run this script as an Administrator!",
        "Insufficient Permissions",
        [System.Windows.Forms.MessageBoxButtons]::OK,
        [System.Windows.Forms.MessageBoxIcon]::Error
    )
    exit
}

# Define the restore point description and type
$description = "Flyoobe Restore Point"
$restorePointType = 12  # MODIFY_SETTINGS

function Create-RestorePoint {
    Write-Host "Starting to create restore point..." -ForegroundColor Yellow

    for ($i = 0; $i -le 100; $i += 10) {
        Write-Progress -Activity "Creating Restore Point" -Status "$i% Complete" -PercentComplete $i
        Start-Sleep -Milliseconds 300
    }

    try {
        $restoreService = Get-WmiObject -Namespace "root\default" -Class SystemRestore
        $result = $restoreService.CreateRestorePoint($description, $restorePointType, 100)

        if ($result -eq 0) {
            Write-Host "Restore point created successfully." -ForegroundColor Green
            [System.Windows.Forms.MessageBox]::Show("Restore point has been created successfully!", "Success", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Information)
        } else {
            Write-Warning "Failed to create restore point. Error code: $result"
            [System.Windows.Forms.MessageBox]::Show("Failed to create restore point. Error code: $result", "Error", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Error)
        }
    } catch {
        Write-Error "An error occurred while creating the restore point: $_"
        [System.Windows.Forms.MessageBox]::Show("An unexpected error occurred: $_", "Exception", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Error)
    }
}

# Execute the restore point creation
Create-RestorePoint
